/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.util;

import com.gprinter.interfaces.CallBackInterface;
import com.gprinter.model.DataInfoModel;
import com.gprinter.model.DeviceInfoModel;
import com.gprinter.util.LogInfo;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.ksoap2.SoapEnvelope;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.ksoap2.transport.HttpTransportSE;
import org.xmlpull.v1.XmlPullParserException;

public class WebServiceUtil {
    private static final String targetNameSpace = "http://tempuri.org/";
    private static final String WSDL = "http://61.143.38.128:8080/Service.asmx";
    private static final String uploadData = "UploadData";

    public static void callWebService(final String json, final CallBackInterface callBack) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SoapObject soapObject = new SoapObject(WebServiceUtil.targetNameSpace, WebServiceUtil.uploadData);
                soapObject.addProperty("json", (Object)json);
                SoapSerializationEnvelope envelop = new SoapSerializationEnvelope(100);
                envelop.dotNet = true;
                envelop.setOutputSoapObject((Object)soapObject);
                HttpTransportSE httpSE = new HttpTransportSE(WebServiceUtil.WSDL);
                try {
                    httpSE.call("http://tempuri.org/UploadData", (SoapEnvelope)envelop);
                    Object resultObj = envelop.getResponse();
                    if (resultObj == null) {
                        LogInfo.out("WebService\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a");
                    } else {
                        LogInfo.out("WebService\u8fd4\u56de\u7ed3\u679c\uff1a " + resultObj.toString());
                        if (callBack != null) {
                            callBack.onCallBack(true);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (callBack != null) {
                        callBack.onCallBack(false);
                    }
                }
                catch (XmlPullParserException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public static JSONObject createJSONObject(DeviceInfoModel deviceInfoModel, List<DataInfoModel> dataInfoModelList, List<Integer> statusList) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("mobilename", (Object)deviceInfoModel.getMobileName());
            jsonObject.put("androidid", (Object)deviceInfoModel.getAndroidId());
            jsonObject.put("osversion", (Object)deviceInfoModel.getOsVersion());
            jsonObject.put("deviceid", (Object)deviceInfoModel.getDeviceId());
            jsonObject.put("iccid", (Object)deviceInfoModel.getIccid());
            jsonObject.put("macaddress", (Object)deviceInfoModel.getMacAddress());
            jsonObject.put("ipaddress", (Object)deviceInfoModel.getIpAddress());
            jsonObject.put("uptime", (Object)deviceInfoModel.getUpTime());
            jsonObject.put("allappnum", deviceInfoModel.getAllAppNum());
            jsonObject.put("installedapp", (Object)deviceInfoModel.getInstalledApp());
            jsonObject.put("uuid", (Object)deviceInfoModel.getUuid());
            jsonObject.put("datetime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(deviceInfoModel.getDateTime()));
            JSONObject dataEle1 = new JSONObject();
            DataInfoModel dataModel1 = dataInfoModelList.get(0);
            dataEle1.put("datetime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dataModel1.getDateTime()));
            dataEle1.put("processcpurate", dataModel1.getProcessCpuRate());
            dataEle1.put("appmem", dataModel1.getAppMem());
            dataEle1.put("systemavailablemem", dataModel1.getSystemAvailableMem());
            dataEle1.put("memrate", dataModel1.getMemRate());
            dataEle1.put("status", (Object)statusList.get(0));
            JSONObject dataEle2 = new JSONObject();
            DataInfoModel dataModel2 = dataInfoModelList.get(1);
            dataEle2.put("datetime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dataModel2.getDateTime()));
            dataEle2.put("processcpurate", dataModel2.getProcessCpuRate());
            dataEle2.put("appmem", dataModel2.getAppMem());
            dataEle2.put("systemavailablemem", dataModel2.getSystemAvailableMem());
            dataEle2.put("memrate", dataModel2.getMemRate());
            dataEle2.put("status", (Object)statusList.get(1));
            JSONObject dataEle3 = new JSONObject();
            DataInfoModel dataModel3 = dataInfoModelList.get(2);
            dataEle3.put("datetime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dataModel3.getDateTime()));
            dataEle3.put("processcpurate", dataModel3.getProcessCpuRate());
            dataEle3.put("appmem", dataModel3.getAppMem());
            dataEle3.put("systemavailablemem", dataModel3.getSystemAvailableMem());
            dataEle3.put("memrate", dataModel3.getMemRate());
            dataEle3.put("status", (Object)statusList.get(2));
            JSONArray jsonArray = new JSONArray();
            jsonArray.put(0, (Object)dataEle1);
            jsonArray.put(1, (Object)dataEle2);
            jsonArray.put(2, (Object)dataEle3);
            jsonObject.put("data", (Object)jsonArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }

    public static JSONObject createJSONObject(DeviceInfoModel deviceInfoModel, List<DataInfoModel> dataInfoModelList) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("mobilename", (Object)deviceInfoModel.getMobileName());
            jsonObject.put("androidid", (Object)deviceInfoModel.getAndroidId());
            jsonObject.put("osversion", (Object)deviceInfoModel.getOsVersion());
            jsonObject.put("deviceid", (Object)deviceInfoModel.getDeviceId());
            jsonObject.put("iccid", (Object)deviceInfoModel.getIccid());
            jsonObject.put("macaddress", (Object)deviceInfoModel.getMacAddress());
            jsonObject.put("ipaddress", (Object)deviceInfoModel.getIpAddress());
            jsonObject.put("uptime", (Object)deviceInfoModel.getUpTime());
            jsonObject.put("allappnum", deviceInfoModel.getAllAppNum());
            jsonObject.put("installedapp", (Object)deviceInfoModel.getInstalledApp());
            jsonObject.put("uuid", (Object)deviceInfoModel.getUuid());
            jsonObject.put("datetime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(deviceInfoModel.getDateTime()));
            JSONObject dataEle1 = new JSONObject();
            DataInfoModel dataModel1 = dataInfoModelList.get(0);
            dataEle1.put("datetime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dataModel1.getDateTime()));
            dataEle1.put("processcpurate", dataModel1.getProcessCpuRate());
            dataEle1.put("appmem", dataModel1.getAppMem());
            dataEle1.put("systemavailablemem", dataModel1.getSystemAvailableMem());
            dataEle1.put("memrate", dataModel1.getMemRate());
            JSONObject dataEle2 = new JSONObject();
            DataInfoModel dataModel2 = dataInfoModelList.get(1);
            dataEle2.put("datetime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dataModel2.getDateTime()));
            dataEle2.put("processcpurate", dataModel2.getProcessCpuRate());
            dataEle2.put("appmem", dataModel2.getAppMem());
            dataEle2.put("systemavailablemem", dataModel2.getSystemAvailableMem());
            dataEle2.put("memrate", dataModel2.getMemRate());
            JSONObject dataEle3 = new JSONObject();
            DataInfoModel dataModel3 = dataInfoModelList.get(2);
            dataEle3.put("datetime", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dataModel3.getDateTime()));
            dataEle3.put("processcpurate", dataModel3.getProcessCpuRate());
            dataEle3.put("appmem", dataModel3.getAppMem());
            dataEle3.put("systemavailablemem", dataModel3.getSystemAvailableMem());
            dataEle3.put("memrate", dataModel3.getMemRate());
            JSONArray jsonArray = new JSONArray();
            jsonArray.put(0, (Object)dataEle1);
            jsonArray.put(1, (Object)dataEle2);
            jsonArray.put(2, (Object)dataEle3);
            jsonObject.put("data", (Object)jsonArray);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jsonObject;
    }
}

