/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.service;

import android.content.Context;
import com.gprinter.interfaces.CallBackInterface;
import com.gprinter.model.DataInfoLog;
import com.gprinter.model.DataInfoModel;
import com.gprinter.model.DeviceInfoModel;
import com.gprinter.printer.DeviceInfoManager;
import com.gprinter.service.AllService;
import com.gprinter.util.DBUtil;
import com.gprinter.util.LogInfo;
import com.gprinter.util.ReflectUtils;
import com.gprinter.util.WebServiceUtil;
import com.lidroid.xutils.DbUtils;
import com.lidroid.xutils.db.sqlite.Selector;
import com.lidroid.xutils.exception.DbException;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SendDeviceInfoThread
extends Thread {
    private int time = 1800000;
    private boolean isStop;
    private AllService mAllService;
    private DeviceInfoManager mDeviceInfoManager;
    private static boolean isChecked;
    private DbUtils db;
    private List<DataInfoModel> dataInfoModelList;

    public SendDeviceInfoThread(AllService allService) {
        this.mAllService = allService;
        this.mDeviceInfoManager = allService.getDeviceInfoManager();
        this.db = DBUtil.getDB((Context)this.mAllService);
        this.setDaemon(true);
        this.setName("SmartPrinter-SendDeviceInfoThread");
        Properties properties = new Properties();
        try {
            properties.load(allService.getAssets().open("interval.properties"));
            this.time = Integer.parseInt(properties.getProperty("send"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LogInfo.out("send time ->" + this.time);
    }

    @Override
    public void run() {
        while (!this.isStop) {
            try {
                Thread.sleep(this.time);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.mAllService == null) continue;
            this.upDataImmediately(isChecked);
        }
    }

    private void upDataImmediately(boolean isFilter) {
        DeviceInfoModel deviceInfoModel = this.mDeviceInfoManager.getDeviceInfo(isChecked);
        try {
            long ago = new Date().getTime() - (long)this.time;
            this.dataInfoModelList = this.db.findAll(Selector.from(DataInfoModel.class).where("dateTime", ">", (Object)ago));
            if (isFilter && this.dataInfoModelList.size() == 0 && !isChecked) {
                LogInfo.out("===\u6570\u636e\u5e93\u6570\u636e\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u672c\u6b21\u64cd\u4f5c===");
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            JSONObject deviceData = new JSONObject();
            JSONArray jsonArray = new JSONArray();
            for (DataInfoModel dm : this.dataInfoModelList) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("datetime", (Object)sdf.format(dm.getDateTime()));
                jsonObj.put("processcpurate", dm.getProcessCpuRate());
                jsonObj.put("appmem", dm.getAppMem());
                jsonObj.put("systemavailablemem", dm.getSystemAvailableMem());
                jsonObj.put("memrate", dm.getMemRate());
                jsonObj.put("status", dm.getStatus());
                jsonArray.put((Object)jsonObj);
            }
            deviceData.put("printername", (Object)deviceInfoModel.getPrinter());
            deviceData.put("brand", (Object)deviceInfoModel.getBrand());
            deviceData.put("mobilename", (Object)deviceInfoModel.getMobileName());
            deviceData.put("osversion", (Object)deviceInfoModel.getOsVersion());
            deviceData.put("androidid", (Object)deviceInfoModel.getAndroidId());
            deviceData.put("deviceid", (Object)deviceInfoModel.getDeviceId());
            deviceData.put("uuid", (Object)deviceInfoModel.getUuid());
            deviceData.put("installedappnum", deviceInfoModel.getInstalledAppNum());
            deviceData.put("iccid", (Object)deviceInfoModel.getIccid());
            deviceData.put("macaddress", (Object)deviceInfoModel.getMacAddress());
            deviceData.put("ipaddress", (Object)deviceInfoModel.getIpAddress());
            deviceData.put("uptime", (Object)deviceInfoModel.getUpTime());
            deviceData.put("installedapp", (Object)deviceInfoModel.getInstalledApp());
            deviceData.put("datetime", (Object)sdf.format(deviceInfoModel.getDateTime()));
            deviceData.put("data", (Object)jsonArray);
            String upData = deviceData.toString();
            LogInfo.out(upData);
            WebServiceUtil.callWebService(upData, new CallBackInterface(){

                @Override
                public void onCallBack(boolean isSuccess) {
                    if (isSuccess) {
                        LogInfo.out("\u8bbe\u5907\u76d1\u63a7\u4fe1\u606f\u6267\u884c\u6210\u529f");
                        try {
                            if (SendDeviceInfoThread.this.db == null) {
                                SendDeviceInfoThread.this.db = DBUtil.getDB((Context)SendDeviceInfoThread.this.mAllService);
                            }
                            SendDeviceInfoThread.this.db.deleteAll(DataInfoModel.class);
                            LogInfo.out("\u8bbe\u5907\u76d1\u63a7\u4fe1\u606f\u5df2\u6e05\u9664");
                        }
                        catch (DbException e) {
                            e.printStackTrace();
                        }
                    } else {
                        LogInfo.out("\u8bbe\u5907\u76d1\u63a7\u4fe1\u606f\u6267\u884c\u5931\u8d25");
                        ArrayList<DataInfoLog> logList = new ArrayList<DataInfoLog>();
                        for (DataInfoModel dm : SendDeviceInfoThread.this.dataInfoModelList) {
                            DataInfoLog dl = new DataInfoLog();
                            dl = ReflectUtils.mappingFieldByField(dm, dl);
                            logList.add(dl);
                        }
                        if (SendDeviceInfoThread.this.db == null) {
                            SendDeviceInfoThread.this.db = DBUtil.getDB((Context)SendDeviceInfoThread.this.mAllService);
                        }
                        try {
                            SendDeviceInfoThread.this.db.saveAll(logList);
                        }
                        catch (DbException e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (DbException | JSONException e) {
            e.printStackTrace();
        }
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setStop(boolean isStop) {
        this.isStop = isStop;
    }

    public static void isChecked(boolean isChecked) {
        SendDeviceInfoThread.isChecked = isChecked;
    }
}

