/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.service;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.app.Service;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.hardware.usb.UsbDevice;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.PowerManager;
import android.os.RemoteException;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import android.widget.Toast;
import com.gprinter.aidl.GpService;
import com.gprinter.command.GpCom;
import com.gprinter.io.GpDevice;
import com.gprinter.io.PortParameters;
import com.gprinter.save.PortParamDataBase;
import com.gprinter.service.AllService;
import com.gprinter.service.SendDeviceInfoThread;
import com.gprinter.util.LogInfo;
import com.lidroid.xutils.DbUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

public class GpPrintService
extends Service {
    private static final String DEBUG_TAG = "GpPrintService";
    public static final String ACTION_PORT_OPEN = "action.port.open";
    public static final String ACTION_PORT_CLOSE = "action.port.close";
    public static final String ACTION_PRINT_TESTPAGE = "action.print.testpage";
    public static final String PRINTER_ID = "printer.id";
    public static final String PORT_TYPE = "port.type";
    public static final String USB_DEVICE_NAME = "usb.devicename";
    public static final String BLUETOOT_ADDR = "bluetooth.addr";
    public static final String IP_ADDR = "port.addr";
    public static final String PORT_NUMBER = "port.number";
    public static final String CONNECT_STATUS = "connect.status";
    public static final String PRINTER_CALLBACK = "printer.callback";
    public static final int MAX_PRINTER_CNT = 20;
    public static final String PRINTER_STATUS = "printer.status";
    public static final String ACTION_PRINTER_STATUS = "action.printer.status";
    private static GpDevice[] mDevice = new GpDevice[20];
    private boolean[] mIsAuth = new boolean[20];
    public static final String KEY_USER_EXPERIENCE = "UserExperience";
    public static final String BrocastAction = "com.gprinter.service.ReadBrocastReceiver";
    public static final String ACTION_CONNECT_STATUS = "action.connect.status";
    public static final String PRINTER_SERVICE = "com.gprinter.aidl.GpPrintService";
    public static final String ALLSERVICE = "com.gprinter.service.ALLSERVICE";
    public static final String SMPRINT_SERVICE = "com.gprinter.service.SmPrintService";
    public static String IMSI;
    public static int PrinterId;
    @SuppressLint(value={"SdCardPath"})
    public static String DB_DIR;
    public static final String DB_NAME = "smartprint.db";
    public static DbUtils db;
    public static String CLIENTNUM;
    private PowerManager.WakeLock wakeLock = null;
    private int mTimeout = 1000;
    private int mServiceTimeout = 4000;
    public static final Object object;
    private boolean mIsReceivedStatus;
    public static final byte FLAG = 16;
    GpService.Stub aidls = new GpService.Stub(){

        public int openPort(int PrinterId, int PortType, String DeviceName, int PortNumber) throws RemoteException {
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            int type = PortType;
            int id = PrinterId;
            Log.d((String)GpPrintService.DEBUG_TAG, (String)("port type " + type + "PrinterId " + id));
            switch (type) {
                case 2: {
                    String name = DeviceName;
                    Log.d((String)GpPrintService.DEBUG_TAG, (String)("port addr " + name));
                    retval = mDevice[id].openUSBPort((Context)GpPrintService.this, id, name, GpPrintService.this.mHandler);
                    break;
                }
                case 4: {
                    String addr = DeviceName;
                    retval = mDevice[id].openBluetoothPort(id, addr, GpPrintService.this.mHandler);
                    break;
                }
                case 3: {
                    int port = PortNumber;
                    String addr = DeviceName;
                    retval = mDevice[id].openEthernetPort(id, addr, port, GpPrintService.this.mHandler);
                }
            }
            return retval.ordinal();
        }

        public void closePort(int PrinterId) throws RemoteException {
            mDevice[PrinterId].closePort();
            ((GpPrintService)GpPrintService.this).mIsAuth[PrinterId] = false;
        }

        public int printeTestPage(int PrinterId) throws RemoteException {
            Log.d((String)GpPrintService.DEBUG_TAG, (String)"printeTestPage ");
            int rel = GpPrintService.this.printTestPage(PrinterId);
            return rel;
        }

        public int sendEscCommand(int PrinterId, String b64) throws RemoteException {
            Log.d((String)GpPrintService.DEBUG_TAG, (String)"sendEscCommand");
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            if (mDevice[PrinterId].getCommandType() == 0) {
                byte[] datas = Base64.decode((String)b64, (int)0);
                Vector<Byte> vector = new Vector<Byte>();
                byte[] byArray = datas;
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    vector.add(b);
                    ++n2;
                }
                retval = mDevice[PrinterId].sendDataImmediately(vector);
            } else {
                retval = GpCom.ERROR_CODE.FAILED;
            }
            return retval.ordinal();
        }

        public int sendLabelCommand(int PrinterId, String b64) throws RemoteException {
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            if (mDevice[PrinterId].getCommandType() == 1) {
                byte[] datas = Base64.decode((String)b64, (int)0);
                Vector<Byte> vector = new Vector<Byte>();
                byte[] byArray = datas;
                int n = datas.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    vector.add(b);
                    ++n2;
                }
                retval = mDevice[PrinterId].sendDataImmediately(vector);
            } else {
                retval = GpCom.ERROR_CODE.FAILED;
            }
            return retval.ordinal();
        }

        public synchronized void queryPrinterStatus(final int PrinterId, int Timesout, int requestCode) throws RemoteException {
            GpPrintService.this.mIsReceivedStatus = false;
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            boolean status = true;
            byte[] esc = new byte[]{16, 4, 2};
            byte[] tsc = new byte[]{27, 33, 63};
            Vector<Byte> data = null;
            Log.i((String)GpPrintService.DEBUG_TAG, (String)"queryPrintStatus ");
            if (mDevice[PrinterId].getConnectState() == 3) {
                if (mDevice[PrinterId].getCommandType() == 0) {
                    data = new Vector<Byte>(esc.length);
                    int i = 0;
                    while (i < esc.length) {
                        data.add(esc[i]);
                        ++i;
                    }
                } else {
                    data = new Vector(tsc.length);
                    int i = 0;
                    while (i < tsc.length) {
                        data.add(tsc[i]);
                        ++i;
                    }
                }
                GpDevice.mReceiveQueue.offer(requestCode);
                mDevice[PrinterId].sendDataImmediately(data);
                GpPrintService.this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        if (!GpPrintService.this.mIsReceivedStatus) {
                            byte[] statusBytes = new byte[]{16};
                            Message msg = GpPrintService.this.mHandler.obtainMessage(2);
                            Bundle bundle = new Bundle();
                            bundle.putInt(GpPrintService.PRINTER_ID, PrinterId);
                            bundle.putInt("device.readcnt", 1);
                            bundle.putByteArray("device.read", statusBytes);
                            msg.setData(bundle);
                            GpPrintService.this.mHandler.sendMessage(msg);
                        }
                    }
                }, (long)Timesout);
            } else {
                GpDevice.mReceiveQueue.add(requestCode);
                byte[] statusBytes = new byte[]{1};
                Message msg = GpPrintService.this.mHandler.obtainMessage(6);
                Bundle bundle = new Bundle();
                bundle.putInt(GpPrintService.PRINTER_ID, PrinterId);
                bundle.putInt("device.readcnt", 1);
                bundle.putByteArray("device.read", statusBytes);
                msg.setData(bundle);
                GpPrintService.this.mHandler.sendMessage(msg);
            }
        }

        public int getPrinterCommandType(int PrinterId) throws RemoteException {
            int type = mDevice[PrinterId].getCommandType();
            return type;
        }

        public int getPrinterConnectStatus(int PrinterId) throws RemoteException {
            int status = mDevice[PrinterId].getConnectState();
            return status;
        }

        public void isUserExperience(boolean userExperience) throws RemoteException {
            SharedPreferences sharedPreference = PreferenceManager.getDefaultSharedPreferences((Context)GpPrintService.this);
            sharedPreference.edit().putBoolean("key_ischecked", userExperience);
            SendDeviceInfoThread.isChecked(userExperience);
        }

        public String getClientID() throws RemoteException {
            return "";
        }

        public int setServerIP(String ip, int port) throws RemoteException {
            return 0;
        }
    };
    private BroadcastReceiver PortOperateBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (GpPrintService.ACTION_PORT_OPEN.equals(intent.getAction())) {
                Log.d((String)GpPrintService.DEBUG_TAG, (String)"PortOperateBroadcastReceiver action.port.open");
                GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
                int type = intent.getIntExtra(GpPrintService.PORT_TYPE, 0);
                int id = intent.getIntExtra(GpPrintService.PRINTER_ID, 0);
                Log.d((String)GpPrintService.DEBUG_TAG, (String)("port type " + type + "PrinterId " + id));
                switch (type) {
                    case 2: {
                        String name = intent.getStringExtra(GpPrintService.USB_DEVICE_NAME);
                        Log.d((String)GpPrintService.DEBUG_TAG, (String)("port addr " + name));
                        retval = mDevice[id].openUSBPort((Context)GpPrintService.this, id, name, GpPrintService.this.mHandler);
                        break;
                    }
                    case 4: {
                        String addr = intent.getStringExtra(GpPrintService.BLUETOOT_ADDR);
                        retval = mDevice[id].openBluetoothPort(id, addr, GpPrintService.this.mHandler);
                        break;
                    }
                    case 3: {
                        int port = intent.getIntExtra(GpPrintService.PORT_NUMBER, 9100);
                        String addr = intent.getStringExtra(GpPrintService.IP_ADDR);
                        retval = mDevice[id].openEthernetPort(id, addr, port, GpPrintService.this.mHandler);
                    }
                }
                if (retval != GpCom.ERROR_CODE.SUCCESS) {
                    GpPrintService.this.showError(retval);
                }
            } else if (GpPrintService.ACTION_PORT_CLOSE.equals(intent.getAction())) {
                int id = intent.getIntExtra(GpPrintService.PRINTER_ID, 0);
                Log.d((String)GpPrintService.DEBUG_TAG, (String)("PrinterId " + id));
                mDevice[id].closePort();
            } else if (GpPrintService.ACTION_PRINT_TESTPAGE.equals(intent.getAction())) {
                int id = intent.getIntExtra(GpPrintService.PRINTER_ID, 0);
                GpPrintService.this.printTestPage(id);
            } else if ("android.bluetooth.device.action.ACL_DISCONNECTED".equals(intent.getAction())) {
                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                GpPrintService.this.disconnectBluetoothDevice(device.getAddress());
            } else if ("android.hardware.usb.action.USB_DEVICE_DETACHED".equals(intent.getAction())) {
                UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                GpPrintService.this.disconnectUsbDevice(device.getDeviceName());
            }
        }
    };
    private boolean isServiceStart;
    private final Handler mHandler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("MESSAGE_STATE_CHANGE: " + msg.arg1));
                    int type = msg.getData().getInt("device_status");
                    final int id = msg.getData().getInt(GpPrintService.PRINTER_ID);
                    switch (type) {
                        case 3: {
                            Log.i((String)GpPrintService.DEBUG_TAG, (String)"STATE_CONNECTED");
                            Vector<Byte> vector = new Vector<Byte>();
                            vector.add((byte)29);
                            vector.add((byte)73);
                            vector.add((byte)67);
                            mDevice[id].sendDataImmediately(vector);
                            Log.d((String)"GpPrintUsb", (String)"send auth 1");
                            GpPrintService.this.mHandler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    if (!GpPrintService.this.mIsAuth[id]) {
                                        Log.d((String)"GpPrintUsb", (String)"send auth label 3");
                                        Vector<Byte> tscAuth = new Vector<Byte>();
                                        tscAuth.add((byte)126);
                                        tscAuth.add((byte)33);
                                        tscAuth.add((byte)84);
                                        Log.d((String)"GpPrintUsbPort", (String)"send ~!T");
                                        mDevice[id].sendDataImmediately(tscAuth);
                                        GpPrintService.this.mHandler.postDelayed(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (!GpPrintService.this.mIsAuth[id]) {
                                                    mDevice[id].closePort();
                                                }
                                            }
                                        }, 4000L);
                                    }
                                }
                            }, 4000L);
                            break;
                        }
                        case 2: {
                            Log.i((String)GpPrintService.DEBUG_TAG, (String)"STATE_CONNECTING");
                            break;
                        }
                        case 0: 
                        case 1: {
                            Log.i((String)GpPrintService.DEBUG_TAG, (String)"STATE_NONE");
                            ((GpPrintService)GpPrintService.this).mIsAuth[id] = false;
                        }
                    }
                    Intent intent = new Intent(GpPrintService.ACTION_CONNECT_STATUS);
                    intent.putExtra(GpPrintService.CONNECT_STATUS, type);
                    intent.putExtra(GpPrintService.PRINTER_ID, id);
                    GpPrintService.this.sendBroadcast(intent);
                    break;
                }
                case 3: {
                    break;
                }
                case 2: {
                    int printerId = msg.getData().getInt(GpPrintService.PRINTER_ID);
                    int cnt = msg.getData().getInt("device.readcnt");
                    byte[] readBuf = msg.getData().getByteArray("device.read");
                    ArrayList<Byte> data = new ArrayList<Byte>();
                    int i = 0;
                    while (i < cnt) {
                        if (readBuf[i] != 19 && readBuf[i] != 17) {
                            data.add(readBuf[i]);
                        }
                        ++i;
                    }
                    if (!GpPrintService.this.mIsAuth[printerId]) {
                        byte[] device = new byte[cnt];
                        int size = data.size();
                        int i2 = 0;
                        while (i2 < size) {
                            device[i2] = (Byte)data.get(i2);
                            ++i2;
                        }
                        String name = new String(device, 0, size);
                        new PortParamDataBase((Context)GpPrintService.this).insertPrinterName(printerId, name);
                        ((GpPrintService)GpPrintService.this).mIsAuth[printerId] = GpPrintService.this.IsGprinter(printerId, device);
                        Log.d((String)GpPrintService.DEBUG_TAG, (String)("RESULT AUTH->" + GpPrintService.this.mIsAuth[printerId]));
                        Log.d((String)GpPrintService.DEBUG_TAG, (String)("size->" + size));
                        if (!GpPrintService.this.mIsAuth[printerId]) break;
                        GpPrintService.this.sendConnectionStatusBroadcastToFront(printerId);
                        break;
                    }
                    GpPrintService.this.mIsReceivedStatus = true;
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("readMessage cnt" + cnt));
                    if (mDevice[printerId].getCommandType() == 0) {
                        if (cnt > 1) break;
                        int result = GpPrintService.this.judgeResponseType(readBuf[0]);
                        if (result == 0) {
                            if (readBuf[0] != 0) break;
                            GpPrintService.this.sendFinishBroadcastToFront(printerId);
                            break;
                        }
                        if (result != 1) break;
                        GpPrintService.this.sendStatusBroadcastToFront(printerId, readBuf[0]);
                        break;
                    }
                    if (mDevice[printerId].getCommandType() != 1) break;
                    if (cnt == 1) {
                        GpPrintService.this.sendStatusBroadcastToFront(printerId, readBuf[0]);
                        break;
                    }
                    GpPrintService.this.sendResponseBroadcastToFront(printerId, readBuf, cnt);
                    break;
                }
                case 4: {
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("DeviceName: " + msg.getData().getString("device_name")));
                    break;
                }
                case 5: {
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("MessageToast: " + msg.getData().getString("toast")));
                    Toast.makeText((Context)GpPrintService.this, (CharSequence)msg.getData().getString("toast"), (int)0).show();
                    break;
                }
                case 6: {
                    GpPrintService.this.mIsReceivedStatus = true;
                    int pid = msg.getData().getInt(GpPrintService.PRINTER_ID);
                    int cnt = msg.getData().getInt("device.readcnt");
                    byte[] readBuf = msg.getData().getByteArray("device.read");
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("readMessage byte " + readBuf[0]));
                    Log.i((String)GpPrintService.DEBUG_TAG, (String)("readMessage cnt" + cnt));
                    GpPrintService.this.sendStatusBroadcastToFront(pid, readBuf[0]);
                }
            }
            return false;
        }
    });

    static {
        PrinterId = 1;
        db = null;
        CLIENTNUM = null;
        object = new Object();
    }

    public void onCreate() {
        super.onCreate();
        Log.d((String)DEBUG_TAG, (String)"-Service onCreate-");
        this.acquireWakeLock();
        this.registerUserPortActionBroadcast();
        this.initUpService();
        int i = 0;
        while (i < 20) {
            GpPrintService.mDevice[i] = new GpDevice();
            ++i;
        }
    }

    private void initUpService() {
        DB_DIR = this.getExternalFilesDir(null).toString();
        String macAddress = this.getWIFIMacAddress();
        IMSI = this.getIMSI(macAddress);
        LogInfo.out("IMSI:" + IMSI);
        CLIENTNUM = GpPrintService.getClientNUM(IMSI);
    }

    public void registerUserPortActionBroadcast() {
        IntentFilter filter = new IntentFilter();
        filter.addAction(ACTION_PORT_OPEN);
        filter.addAction(ACTION_PORT_CLOSE);
        filter.addAction(ACTION_PRINT_TESTPAGE);
        filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        filter.addAction("android.hardware.usb.action.USB_DEVICE_DETACHED");
        this.registerReceiver(this.PortOperateBroadcastReceiver, filter);
    }

    public void onStart(Intent intent, int startId) {
        Log.d((String)DEBUG_TAG, (String)"-Service onStart-");
    }

    public void onDestroy() {
        Log.d((String)DEBUG_TAG, (String)"-Service onDestory-");
        this.unregisterReceiver(this.PortOperateBroadcastReceiver);
        this.releaseWakeLock();
        super.onDestroy();
    }

    public boolean onUnbind(Intent intent) {
        Log.d((String)DEBUG_TAG, (String)"-Service onUnbind-");
        return super.onUnbind(intent);
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
        Log.d((String)DEBUG_TAG, (String)"-Service onRebind-");
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.d((String)DEBUG_TAG, (String)"-Service onStartCommand-");
        return 1;
    }

    public IBinder onBind(Intent intent) {
        System.out.println("Service onBind");
        return this.aidls;
    }

    public boolean[] getConnectState() {
        boolean[] state = new boolean[20];
        int i = 0;
        while (i < 20) {
            state[i] = false;
            ++i;
        }
        i = 0;
        while (i < 20) {
            if (mDevice[i] != null) {
                Log.d((String)DEBUG_TAG, (String)("getConnectState " + i));
                if (mDevice[i].getConnectState() == 3) {
                    state[i] = true;
                }
            }
            ++i;
        }
        return state;
    }

    private void showError(GpCom.ERROR_CODE retval) {
        GpCom.getErrorText(retval);
    }

    private void disconnectBluetoothDevice(String addr) {
        int i = 0;
        while (i < 20) {
            PortParameters p = mDevice[i].getPortParameters();
            if (p.getPortType() == 4 && p.getBluetoothAddr().equals(addr)) {
                mDevice[i].closePort();
                break;
            }
            ++i;
        }
    }

    private void disconnectUsbDevice(String name) {
        int i = 0;
        while (i < 20) {
            PortParameters p = mDevice[i].getPortParameters();
            if (p.getPortType() == 2 && p.getUsbDeviceName().equals(name)) {
                mDevice[i].closePort();
                break;
            }
            ++i;
        }
    }

    int printTestPage(int id) {
        GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
        Vector<Byte> TestPageData = null;
        if (mDevice[id].getConnectState() == 3) {
            if (mDevice[id].getCommandType() == 0) {
                if (this.getResources().getConfiguration().locale.getCountry().equals("CN")) {
                    TestPageData = this.getTestPageData("/esc_CN.txt");
                    Log.d((String)DEBUG_TAG, (String)"Send  ESC data ");
                } else {
                    TestPageData = this.getTestPageData("/esc.txt");
                }
                retval = mDevice[id].sendDataImmediately(TestPageData);
            } else if (mDevice[id].getCommandType() == 1) {
                Log.d((String)DEBUG_TAG, (String)"Send Label data ");
                TestPageData = this.getResources().getConfiguration().locale.getCountry().equals("CN") ? this.getTestPageData("/tsc_CN.txt") : this.getTestPageData("/tsc.txt");
                retval = mDevice[id].sendDataImmediately(TestPageData);
            } else {
                retval = GpCom.ERROR_CODE.INVALID_DEVICE_PARAMETERS;
            }
        } else {
            Log.d((String)DEBUG_TAG, (String)"Port is not connect ");
            retval = GpCom.ERROR_CODE.PORT_IS_NOT_OPEN;
        }
        return retval.ordinal();
    }

    Vector<Byte> getTestPageData(String root) {
        byte[] bs;
        byte[] data;
        block13: {
            data = null;
            Log.d((String)DEBUG_TAG, (String)("PrintTestPageButtonOnClickListener" + root));
            InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(root);
            bs = new byte[8192];
            int len = 0;
            try {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    while ((len = in.read(bs)) != -1) {
                        out.write(bs, 0, len);
                    }
                    data = out.toByteArray();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Vector<Byte> TestPageData = new Vector<Byte>(data.length);
        int i = 0;
        while (i < data.length) {
            TestPageData.add(bs[i]);
            ++i;
        }
        return TestPageData;
    }

    private void sendConnectionStatusBroadcastToFront(final int id) {
        this.isServiceStart = false;
        Log.d((String)DEBUG_TAG, (String)("Current state ->[" + id + "]" + mDevice[id].getConnectState()));
        if (mDevice[id].getConnectState() == 3) {
            final int type = mDevice[id].getCommandType();
            Intent allServiceIntent = new Intent((Context)this, AllService.class);
            allServiceIntent.putExtra("mode", type);
            allServiceIntent.putExtra("printId", id);
            this.startService(allServiceIntent);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    long time = System.currentTimeMillis();
                    long timeout = time + (long)GpPrintService.this.mServiceTimeout;
                    while (time < timeout && !GpPrintService.this.isServiceStart) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        time = System.currentTimeMillis();
                        GpPrintService.this.isServiceStart = GpPrintService.this.isServiceRunning(AllService.class);
                    }
                    if (GpPrintService.this.isServiceStart) {
                        Log.e((String)GpPrintService.DEBUG_TAG, (String)"STATE_VALID_PRINTER");
                        mDevice[id].setCommandType(type);
                        Intent intent = new Intent(GpPrintService.ACTION_CONNECT_STATUS);
                        intent.putExtra(GpPrintService.CONNECT_STATUS, 5);
                        intent.putExtra(GpPrintService.PRINTER_ID, id);
                        GpPrintService.this.sendBroadcast(intent);
                    } else {
                        mDevice[id].closePort();
                        Intent intent = new Intent(GpPrintService.ACTION_CONNECT_STATUS);
                        intent.putExtra(GpPrintService.CONNECT_STATUS, 0);
                        intent.putExtra(GpPrintService.PRINTER_ID, id);
                        GpPrintService.this.sendBroadcast(intent);
                        Message msg = GpPrintService.this.mHandler.obtainMessage(5);
                        Bundle bundle = new Bundle();
                        bundle.putInt(GpPrintService.PRINTER_ID, id);
                        bundle.putString("toast", "Please start service");
                        msg.setData(bundle);
                        GpPrintService.this.mHandler.sendMessage(msg);
                    }
                }
            }).start();
        }
    }

    private void sendFinishBroadcastToFront(int id) {
        Intent statusBroadcast = new Intent("action.device.receipt.response");
        statusBroadcast.putExtra(PRINTER_ID, id);
        this.sendBroadcast(statusBroadcast);
    }

    private void sendStatusBroadcastToFront(int id, int r) {
        Integer requestCode;
        Log.i((String)DEBUG_TAG, (String)("printer disconnect " + r));
        int status = r == 16 ? 16 : 0;
        if (mDevice[id].getConnectState() == 3) {
            if (mDevice[id].getCommandType() == 0) {
                if ((r & 0x20) > 0) {
                    status |= 2;
                }
                if ((r & 4) > 0) {
                    status |= 4;
                }
                if ((r & 0x40) > 0) {
                    status |= 8;
                }
            } else {
                if ((r & 4) > 0) {
                    status |= 2;
                }
                if ((r & 0x40) > 0) {
                    status |= 4;
                }
                if ((r & 0x80) > 0) {
                    status |= 8;
                }
            }
        } else {
            status |= 1;
        }
        if ((requestCode = GpDevice.mReceiveQueue.poll()) == null) {
            return;
        }
        Intent statusBroadcast = new Intent("action.device.real.status");
        statusBroadcast.putExtra("action.printer.real.status", status);
        statusBroadcast.putExtra(PRINTER_ID, id);
        statusBroadcast.putExtra("printer.request_code", (Serializable)requestCode);
        this.sendBroadcast(statusBroadcast);
    }

    private void sendResponseBroadcastToFront(int id, byte[] response, int cnt) {
        Intent statusBroadcast = new Intent("action.device.label.response");
        statusBroadcast.putExtra(PRINTER_ID, id);
        statusBroadcast.putExtra("printer.label.response", response);
        statusBroadcast.putExtra("printer.label.response.cnt", cnt);
        this.sendBroadcast(statusBroadcast);
    }

    private int judgeResponseType(byte r) {
        byte result = (byte)((r & 0x10) >> 4);
        return result;
    }

    private boolean judgePrinter(byte[] table, byte[] readPrinter) {
        int i;
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < readPrinter.length) {
            sb.append(readPrinter[i2]);
            sb.append(" ");
            ++i2;
        }
        Log.d((String)DEBUG_TAG, (String)sb.toString());
        boolean result = false;
        int readLength = readPrinter.length;
        if (readLength < 5) {
            return result;
        }
        int tableLength = table.length;
        if (tableLength >= readLength) {
            i = 0;
            while (i < readLength) {
                if (table[i] != readPrinter[i]) {
                    return result;
                }
                ++i;
            }
        } else {
            return false;
        }
        result = true;
        if (result) {
            sb.delete(0, sb.length());
            i = 0;
            while (i < table.length) {
                sb.append(table[i]);
                sb.append(" ");
                ++i;
            }
            Log.d((String)DEBUG_TAG, (String)sb.toString());
        }
        return result;
    }

    private boolean IsGprinter(int id, byte[] readBuf) {
        boolean result = false;
        byte[] byArray = new byte[13];
        byArray[0] = 95;
        byArray[1] = 71;
        byArray[2] = 80;
        byArray[3] = 55;
        byArray[4] = 54;
        byArray[5] = 32;
        byArray[6] = 83;
        byArray[7] = 101;
        byArray[8] = 114;
        byArray[9] = 105;
        byArray[10] = 101;
        byArray[11] = 115;
        byte[] PRINTER_NAME_TABLE1 = byArray;
        byte[] byArray2 = new byte[12];
        byArray2[0] = 95;
        byArray2[1] = 71;
        byArray2[2] = 80;
        byArray2[3] = 45;
        byArray2[4] = 50;
        byArray2[5] = 51;
        byArray2[6] = 51;
        byArray2[7] = 48;
        byArray2[8] = 73;
        byArray2[9] = 86;
        byArray2[10] = 67;
        byte[] PRINTER_NAME_TABLE2 = byArray2;
        byte[] byArray3 = new byte[12];
        byArray3[0] = 95;
        byArray3[1] = 71;
        byArray3[2] = 80;
        byArray3[3] = 53;
        byArray3[4] = 56;
        byArray3[5] = 57;
        byArray3[6] = 48;
        byArray3[7] = 88;
        byArray3[8] = 73;
        byArray3[9] = 73;
        byArray3[10] = 73;
        byte[] PRINTER_NAME_TABLE3 = byArray3;
        byte[] byArray4 = new byte[11];
        byArray4[0] = 95;
        byArray4[1] = 71;
        byArray4[2] = 80;
        byArray4[3] = 45;
        byArray4[4] = 76;
        byArray4[5] = 56;
        byArray4[6] = 48;
        byArray4[7] = 49;
        byArray4[8] = 54;
        byArray4[9] = 48;
        byte[] PRINTER_NAME_TABLE4 = byArray4;
        byte[] byArray5 = new byte[11];
        byArray5[0] = 95;
        byArray5[1] = 71;
        byArray5[2] = 80;
        byArray5[3] = 45;
        byArray5[4] = 76;
        byArray5[5] = 56;
        byArray5[6] = 48;
        byArray5[7] = 51;
        byArray5[8] = 48;
        byArray5[9] = 48;
        byte[] PRINTER_NAME_TABLE5 = byArray5;
        byte[] byArray6 = new byte[11];
        byArray6[0] = 95;
        byArray6[1] = 71;
        byArray6[2] = 80;
        byArray6[3] = 45;
        byArray6[4] = 56;
        byArray6[5] = 48;
        byArray6[6] = 49;
        byArray6[7] = 50;
        byArray6[8] = 48;
        byArray6[9] = 73;
        byte[] PRINTER_NAME_TABLE6 = byArray6;
        byte[] byArray7 = new byte[10];
        byArray7[0] = 95;
        byArray7[1] = 71;
        byArray7[2] = 80;
        byArray7[3] = 45;
        byArray7[4] = 53;
        byArray7[5] = 56;
        byArray7[6] = 49;
        byArray7[7] = 51;
        byArray7[8] = 48;
        byte[] PRINTER_NAME_TABLE7 = byArray7;
        byte[] byArray8 = new byte[9];
        byArray8[0] = 95;
        byArray8[1] = 71;
        byArray8[2] = 80;
        byArray8[3] = 53;
        byArray8[4] = 56;
        byArray8[5] = 49;
        byArray8[6] = 51;
        byArray8[7] = 48;
        byte[] PRINTER_NAME_TABLE8 = byArray8;
        byte[] byArray9 = new byte[9];
        byArray9[0] = 95;
        byArray9[1] = 71;
        byArray9[2] = 80;
        byArray9[3] = 50;
        byArray9[4] = 49;
        byArray9[5] = 50;
        byArray9[6] = 48;
        byArray9[7] = 84;
        byte[] PRINTER_NAME_TABLE9 = byArray9;
        byte[] byArray10 = new byte[9];
        byArray10[0] = 95;
        byArray10[1] = 71;
        byArray10[2] = 80;
        byArray10[3] = 45;
        byArray10[4] = 85;
        byArray10[5] = 52;
        byArray10[6] = 50;
        byArray10[7] = 48;
        byte[] PRINTER_NAME_TABLE10 = byArray10;
        byte[] byArray11 = new byte[8];
        byArray11[0] = 95;
        byArray11[1] = 71;
        byArray11[2] = 80;
        byArray11[3] = 53;
        byArray11[4] = 56;
        byArray11[5] = 57;
        byArray11[6] = 48;
        byte[] PRINTER_NAME_TABLE11 = byArray11;
        byte[] byArray12 = new byte[7];
        byArray12[0] = 95;
        byArray12[1] = 80;
        byArray12[2] = 84;
        byArray12[3] = 50;
        byArray12[4] = 56;
        byArray12[5] = 48;
        byte[] PRINTER_NAME_TABLE12 = byArray12;
        byte[] byArray13 = new byte[6];
        byArray13[0] = 95;
        byArray13[1] = 80;
        byArray13[2] = 114;
        byArray13[3] = 111;
        byArray13[4] = 53;
        byte[] PRINTER_NAME_TABLE13 = byArray13;
        byte[] PRINTER_NAME_TABLE14 = new byte[]{71, 80, 75, 83, 45};
        byte[] PRINTER_TYPE1 = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 51, 49, 50, 48, 84, 76, 13, 10};
        byte[] PRINTER_TYPE2 = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 57, 48, 51, 52, 84, 13, 10};
        byte[] PRINTER_TYPE3 = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 57, 48, 50, 53, 84, 13, 10};
        byte[] PRINTER_TYPE4 = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 49, 49, 50, 52, 68, 13, 10};
        byte[] PRINTER_TYPE5 = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 49, 49, 50, 52, 84, 13, 10};
        byte[] PRINTER_TYPE6 = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 49, 49, 51, 52, 84, 13, 10};
        byte[] PRINTER_TYPE7 = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 57, 48, 50, 53, 84, 13, 10};
        byte[] PRINTER_TYPE8 = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 57, 49, 51, 52, 84, 13, 10};
        byte[] PRINTER_TYPE9 = new byte[]{77, 79, 68, 69, 76, 58, 71, 80, 45, 50, 49, 50, 48, 13, 10};
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE1, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE2, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE3, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE4, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE5, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE6, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE7, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE8, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE9, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE10, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE11, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE12, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE13, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_NAME_TABLE14, readBuf);
        }
        if (result) {
            mDevice[id].setCommandType(0);
            return result;
        }
        result = this.judgePrinter(PRINTER_TYPE1, readBuf);
        if (!result) {
            result = this.judgePrinter(PRINTER_TYPE2, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_TYPE3, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_TYPE4, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_TYPE5, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_TYPE6, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_TYPE7, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_TYPE8, readBuf);
        }
        if (!result) {
            result = this.judgePrinter(PRINTER_TYPE9, readBuf);
        }
        if (result) {
            mDevice[id].setCommandType(1);
            return result;
        }
        return result;
    }

    public boolean useList(byte[] arr, Object targetValue) {
        return Arrays.asList(new byte[][]{arr}).contains(targetValue);
    }

    private void acquireWakeLock() {
        if (this.wakeLock == null) {
            PowerManager pm = (PowerManager)this.getSystemService("power");
            this.wakeLock = pm.newWakeLock(0x20000001, ((Object)((Object)this)).getClass().getCanonicalName());
            if (this.wakeLock != null) {
                Log.i((String)"-wakeLock-", (String)"wakelock acquireWakeLock");
                this.wakeLock.acquire();
            }
        }
    }

    private void releaseWakeLock() {
        if (this.wakeLock != null && this.wakeLock.isHeld()) {
            Log.i((String)"-releaseWakeLock-", (String)"wakelock releaseWakeLock");
            this.wakeLock.release();
            this.wakeLock = null;
        }
    }

    public static String getClientNUM(String IMSI) {
        if (IMSI.length() != 15) {
            return null;
        }
        String[] map = new String[]{"3", "9", "6", "1", "5", "0", "8", "4", "2", "7"};
        int x = 0;
        int i = 0;
        while (i < IMSI.length()) {
            x = x + IMSI.charAt(i) - 48;
            ++i;
        }
        int y = x + (IMSI.charAt(10) - 48) + (IMSI.charAt(12) - 48) + (IMSI.charAt(14) - 48);
        int z = y % 10;
        String n = map[z];
        String clientNum = String.valueOf(IMSI) + n;
        return clientNum;
    }

    public String getIMSI(String macAddress) {
        if (TextUtils.isEmpty((CharSequence)macAddress)) {
            return "";
        }
        macAddress = macAddress.replaceAll(":", "");
        long long_IMSI = Long.parseLong(macAddress, 16);
        String str_IMSI = String.valueOf(long_IMSI += 100000000000000L);
        return str_IMSI;
    }

    private String getWIFIMacAddress() {
        WifiInfo info;
        String macAddress = null;
        WifiManager wifiMgr = (WifiManager)this.getSystemService("wifi");
        WifiInfo wifiInfo = info = wifiMgr == null ? null : wifiMgr.getConnectionInfo();
        if (info != null) {
            macAddress = info.getMacAddress();
        }
        LogInfo.out("mac:" + macAddress);
        return macAddress;
    }

    private boolean isServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }
}

