/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.usb.UsbDevice;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbEndpoint;
import android.hardware.usb.UsbInterface;
import android.hardware.usb.UsbManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.gprinter.command.GpCom;
import com.gprinter.io.GpPort;
import java.util.HashMap;
import java.util.Vector;

public class UsbPort
extends GpPort {
    private static final String DEBUG_TAG = "UsbPortService";
    public static final String ACTION_USB_DEVICE_ATTACHED = "com.example.ACTION_USB_DEVICE_ATTACHED";
    private static final String ACTION_USB_PERMISSION = "com.android.example.USB_PERMISSION";
    private static final String USB_PRINTER_NAME = "Gprinter";
    private String mUsbDeviceName;
    private UsbManager mUsbManager;
    private ConnectThread mConnectThread = null;
    private ConnectedThread mConnectedThread = null;
    private Context mContext = null;
    private final BroadcastReceiver mUsbPermissionReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (UsbPort.ACTION_USB_PERMISSION.equals(action)) {
                1 var4_4 = this;
                synchronized (var4_4) {
                    UsbDevice device = (UsbDevice)intent.getParcelableExtra("device");
                    if (intent.getBooleanExtra("permission", false)) {
                        if (device != null) {
                            Log.d((String)UsbPort.DEBUG_TAG, (String)("permission ok for device " + device));
                            UsbPort.this.connect();
                        }
                    } else {
                        Log.d((String)UsbPort.DEBUG_TAG, (String)("permission denied for device " + device));
                        UsbPort.this.stop();
                    }
                    UsbPort.this.mContext.unregisterReceiver((BroadcastReceiver)this);
                }
            }
        }
    };

    public UsbPort(Context context, int id, String name, Handler handler) {
        this.mPrinterId = id;
        this.mState = 0;
        this.mHandler = handler;
        this.mUsbDeviceName = name;
        this.mContext = context;
        this.mUsbManager = (UsbManager)context.getSystemService("usb");
    }

    @Override
    public synchronized void connect() {
        Log.d((String)DEBUG_TAG, (String)"connect to usb device ");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(this.mUsbDeviceName);
        this.mConnectThread.start();
        this.setState(2);
    }

    public synchronized void connected(UsbDeviceConnection connection, UsbInterface intf) {
        Log.d((String)DEBUG_TAG, (String)"connected");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectedThread = new ConnectedThread(connection, intf);
        this.mConnectedThread.start();
        Message msg = this.mHandler.obtainMessage(4);
        Bundle bundle = new Bundle();
        bundle.putInt("printer.id", this.mPrinterId);
        bundle.putString("device_name", USB_PRINTER_NAME);
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
        this.setState(3);
    }

    @Override
    public synchronized void stop() {
        Log.d((String)DEBUG_TAG, (String)"stop");
        this.setState(0);
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GpCom.ERROR_CODE writeDataImmediately(Vector<Byte> data) {
        ConnectedThread r;
        GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
        UsbPort usbPort = this;
        synchronized (usbPort) {
            if (this.mState != 3) {
                return GpCom.ERROR_CODE.PORT_IS_NOT_OPEN;
            }
            r = this.mConnectedThread;
        }
        retval = r.writeDataImmediately(data);
        return retval;
    }

    boolean checkUsbDevicePidVid(UsbDevice dev) {
        int pid = dev.getProductId();
        int vid = dev.getVendorId();
        boolean rel = false;
        if (vid == 34918 && pid == 256 || vid == 1137 && pid == 85 || vid == 6790 && pid == 30084 || vid == 26728 && pid == 256 || vid == 26728 && pid == 512 || vid == 26728 && pid == 256 || vid == 26728 && pid == 768 || vid == 26728 && pid == 1024 || vid == 26728 && pid == 1280 || vid == 26728 && pid == 1536 || vid == 7358 && pid == 2) {
            rel = true;
        }
        return rel;
    }

    private class ConnectThread
    extends Thread {
        private UsbDevice mmUSBDevice = null;
        private String mmDeviceName = null;
        private UsbDeviceConnection mmConnection = null;
        private UsbInterface mmIntf;

        public ConnectThread(String devicename) {
            this.mmDeviceName = devicename;
            this.mmUSBDevice = null;
            this.mmConnection = null;
            this.mmIntf = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.i((String)UsbPort.DEBUG_TAG, (String)"BEGIN mConnectThread");
            this.setName("ConnectThread");
            this.mmUSBDevice = null;
            HashMap usbDeviceList = UsbPort.this.mUsbManager.getDeviceList();
            if (!this.mmDeviceName.equals("")) {
                Log.d((String)UsbPort.DEBUG_TAG, (String)"UsbDeviceName not empty. Trying to open it...");
                this.mmUSBDevice = (UsbDevice)usbDeviceList.get(this.mmDeviceName);
            } else {
                Log.d((String)UsbPort.DEBUG_TAG, (String)"PortName is empty. Trying to find Gp device...");
                for (String deviceName : usbDeviceList.keySet()) {
                    UsbDevice device = (UsbDevice)usbDeviceList.get(deviceName);
                    if (!UsbPort.this.checkUsbDevicePidVid(device)) continue;
                    this.mmUSBDevice = device;
                    break;
                }
            }
            if (this.mmUSBDevice != null) {
                if (!UsbPort.this.mUsbManager.hasPermission(this.mmUSBDevice)) {
                    IntentFilter UsbPermissionIntentFilter = new IntentFilter(UsbPort.ACTION_USB_PERMISSION);
                    UsbPort.this.mContext.registerReceiver(UsbPort.this.mUsbPermissionReceiver, UsbPermissionIntentFilter);
                    UsbDevice dev = this.mmUSBDevice;
                    this.mmUSBDevice = null;
                    PendingIntent pi = PendingIntent.getBroadcast((Context)UsbPort.this.mContext, (int)0, (Intent)new Intent(UsbPort.ACTION_USB_PERMISSION), (int)0);
                    if (UsbPort.this.checkUsbDevicePidVid(dev)) {
                        UsbPort.this.mUsbManager.requestPermission(dev, pi);
                    }
                } else {
                    int count = this.mmUSBDevice.getInterfaceCount();
                    UsbInterface intf = null;
                    int i = 0;
                    while (i < count) {
                        intf = this.mmUSBDevice.getInterface(i);
                        if (intf.getInterfaceClass() == 7) break;
                        ++i;
                    }
                    if (intf != null) {
                        this.mmIntf = intf;
                        this.mmConnection = null;
                        this.mmConnection = UsbPort.this.mUsbManager.openDevice(this.mmUSBDevice);
                        if (this.mmConnection != null) {
                            UsbPort usbPort = UsbPort.this;
                            synchronized (usbPort) {
                                UsbPort.this.mConnectThread = null;
                            }
                            UsbPort.this.connected(this.mmConnection, this.mmIntf);
                        } else {
                            UsbPort.this.connectionToPrinterFailed();
                            UsbPort.this.stop();
                        }
                    } else {
                        UsbPort.this.connectionFailed();
                        UsbPort.this.stop();
                    }
                }
            } else {
                Log.e((String)UsbPort.DEBUG_TAG, (String)"Cannot find usb device");
                UsbPort.this.stop();
            }
        }

        public void cancel() {
            if (this.mmConnection != null) {
                this.mmConnection.releaseInterface(this.mmIntf);
                this.mmConnection.close();
            }
            this.mmConnection = null;
        }
    }

    private class ConnectedThread
    extends Thread {
        UsbDeviceConnection mmConnection;
        UsbInterface mmIntf;
        private UsbEndpoint mmEndIn = null;
        private UsbEndpoint mmEndOut = null;

        public ConnectedThread(UsbDeviceConnection Connection, UsbInterface Intf) {
            Log.d((String)UsbPort.DEBUG_TAG, (String)"create ConnectedThread");
            this.mmConnection = Connection;
            this.mmIntf = Intf;
            Log.i((String)UsbPort.DEBUG_TAG, (String)"BEGIN mConnectedThread");
            if (this.mmConnection.claimInterface(this.mmIntf, true)) {
                int i = 0;
                while (i < this.mmIntf.getEndpointCount()) {
                    UsbEndpoint ep = this.mmIntf.getEndpoint(i);
                    if (ep.getType() == 2) {
                        if (ep.getDirection() == 0) {
                            this.mmEndOut = ep;
                        } else {
                            this.mmEndIn = ep;
                        }
                    }
                    ++i;
                }
            }
        }

        @Override
        public void run() {
            if (this.mmEndOut != null && this.mmEndIn != null) {
                UsbPort.this.mClosePort = false;
                while (!UsbPort.this.mClosePort) {
                    try {
                        byte[] ReceiveData = new byte[100];
                        int bytes = this.mmConnection.bulkTransfer(this.mmEndIn, ReceiveData, ReceiveData.length, 200);
                        if (bytes > 0) {
                            Message msg = UsbPort.this.mHandler.obtainMessage(2);
                            Bundle bundle = new Bundle();
                            bundle.putInt("printer.id", UsbPort.this.mPrinterId);
                            bundle.putInt("device.readcnt", bytes);
                            bundle.putByteArray("device.read", ReceiveData);
                            msg.setData(bundle);
                            UsbPort.this.mHandler.sendMessage(msg);
                        }
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException e) {
                        UsbPort.this.connectionLost();
                        break;
                    }
                }
                Log.d((String)UsbPort.DEBUG_TAG, (String)"Closing Usb work");
            } else {
                UsbPort.this.stop();
                UsbPort.this.connectionLost();
            }
        }

        public void cancel() {
            UsbPort.this.mClosePort = true;
            this.mmConnection.releaseInterface(this.mmIntf);
            this.mmConnection.close();
            this.mmConnection = null;
        }

        public GpCom.ERROR_CODE writeDataImmediately(Vector<Byte> data) {
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            if (data != null && data.size() > 0) {
                byte[] sendData = new byte[data.size()];
                int i = 0;
                while (i < data.size()) {
                    sendData[i] = data.get(i);
                    ++i;
                }
                try {
                    int result = this.mmConnection.bulkTransfer(this.mmEndOut, sendData, sendData.length, 500);
                    if (result >= 0) {
                        Log.d((String)UsbPort.DEBUG_TAG, (String)"send success");
                    }
                }
                catch (Exception e) {
                    Log.d((String)UsbPort.DEBUG_TAG, (String)("Exception occured while sending data immediately: " + e.getMessage()));
                    retval = GpCom.ERROR_CODE.FAILED;
                }
            }
            return retval;
        }
    }
}

