/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;
import com.gprinter.io.SerialPort;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.security.InvalidParameterException;
import java.util.Date;

public abstract class GpEquipmentPort
extends SerialPort {
    private SerialPort mSerialPort;
    private ReadThread mReadThread;
    private InputStream mInputStream;
    private Context mContext;
    private String mPath;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private boolean mRequestVersion = false;
    private boolean mPrepareUpdate = false;
    private boolean mUpdating = false;
    private int currentPackage = 0;
    private int mPackOffsetL = 0;
    private int mPackOffsetH = 0;
    private int mSignlePackageSize = 64;
    private byte[] data;
    int index = 0;
    private OnDataReceived mOnDataReceived;

    protected GpEquipmentPort(Context context) {
        super(context);
        this.mContext = context;
    }

    protected SerialPort getSerialPort(File file, int baudrate, int flag) throws SecurityException, IOException, InvalidParameterException {
        if (this.mSerialPort == null) {
            this.mSerialPort = new SerialPort(this.mContext);
            this.mSerialPort.openSerialPort(file, baudrate, flag);
            this.mInputStream = this.mSerialPort.getInputStream();
            this.mReadThread = new ReadThread();
            this.mReadThread.start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    GpEquipmentPort.this.is();
                }
            }).start();
        }
        return this.mSerialPort;
    }

    private void resetFlag() {
        this.mUpdating = false;
        this.mRequestVersion = false;
        this.mPrepareUpdate = false;
    }

    public void closeSerialPort() {
        this.resetFlag();
        if (this.mSerialPort != null) {
            this.mSerialPort.close();
            this.mSerialPort = null;
            if (this.mReadThread != null) {
                this.mReadThread.interrupt();
                this.mReadThread = null;
            }
        }
    }

    protected void setPath(String path) {
        this.mPath = path;
    }

    private int getFileSize() throws IOException {
        int len;
        int fileSize;
        block17: {
            fileSize = 0;
            FileInputStream inputStream = null;
            len = -1;
            if (TextUtils.isEmpty((CharSequence)this.mPath)) {
                throw new IOException("path is invalid");
            }
            try {
                try {
                    inputStream = new FileInputStream(this.mPath);
                    FileChannel fc = inputStream.getChannel();
                    while (inputStream.read() != -1) {
                        ++fileSize;
                    }
                    this.data = new byte[fileSize];
                    fc.position(0L);
                    len = inputStream.read(this.data);
                    Log.d((String)"fileSize =", (String)String.valueOf(len));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (len == -1) {
            throw new IOException("read error");
        }
        return fileSize;
    }

    private void prepareUpdate() throws IOException {
        int fileSize = this.getFileSize();
        boolean addPack = fileSize % 64 == 0;
        int packSize = addPack ? fileSize / 64 : fileSize / 64 + 1;
        int packL = packSize % 256;
        int packH = packSize / 256;
        int sizeL = 64;
        int sizeH = 0;
        this.requestUpdate(packL, packH, sizeL, sizeH);
    }

    public byte[] getUpdateData() {
        int currentPackageIndex = this.mSignlePackageSize * (this.mPackOffsetL + this.mPackOffsetH * 256);
        int calcPackageSize = this.data.length - currentPackageIndex;
        calcPackageSize = calcPackageSize > 64 ? this.mSignlePackageSize : calcPackageSize;
        byte[] d1 = new byte[calcPackageSize];
        System.arraycopy(this.data, currentPackageIndex, d1, 0, calcPackageSize);
        return d1;
    }

    private void callbackIsPortOpen(final boolean isOpen) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GpEquipmentPort.this.mOnDataReceived.onPortOpen(isOpen);
            }
        });
    }

    private void callbackBacklightTimeout(final int t1, final int t2) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                int timeout = t1 + t2 * 256;
                GpEquipmentPort.this.mOnDataReceived.onBacklightTimeout(timeout);
            }
        });
    }

    private void callbackBacklightStatus(final byte buffer) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                boolean isOn;
                if (buffer == -86) {
                    isOn = true;
                } else if (buffer == -35) {
                    isOn = false;
                } else {
                    return;
                }
                GpEquipmentPort.this.mOnDataReceived.onBacklightStatus(isOn);
            }
        });
    }

    private void callbackCursorPosition(final int x, final int y) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GpEquipmentPort.this.mOnDataReceived.onCursorPosition(x, y);
            }
        });
    }

    private void callbackDisplayRowAndColumn(final int x, final int y) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GpEquipmentPort.this.mOnDataReceived.onDisplayRowAndColumn(x, y);
            }
        });
    }

    private void callbackDisplayUpdateSuccess() {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GpEquipmentPort.this.mOnDataReceived.onUpdateSuccess();
            }
        });
    }

    private void callbackDisplayUpdateFail(final String error) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                GpEquipmentPort.this.mOnDataReceived.onUpdateFail(error);
            }
        });
    }

    protected void setDataReceived(OnDataReceived onDataReceived) {
        this.mOnDataReceived = onDataReceived;
    }

    public static interface OnDataReceived {
        public void onPortOpen(boolean var1);

        public void onBacklightStatus(boolean var1);

        public void onCursorPosition(int var1, int var2);

        public void onDisplayRowAndColumn(int var1, int var2);

        public void onBacklightTimeout(int var1);

        public void onUpdateSuccess();

        public void onUpdateFail(String var1);
    }

    private class ReadThread
    extends Thread {
        private ReadThread() {
        }

        @Override
        public void run() {
            Log.d((String)"=======", (String)"Read start");
            byte[] version = new byte[36];
            int versionCnt = 0;
            while (!this.isInterrupted()) {
                try {
                    byte[] buffer = new byte[64];
                    if (GpEquipmentPort.this.mInputStream == null) {
                        return;
                    }
                    int size = GpEquipmentPort.this.mInputStream.read(buffer);
                    if (GpEquipmentPort.this.mOnDataReceived == null) continue;
                    if (GpEquipmentPort.this.mRequestVersion) {
                        int i = 0;
                        while (i < size) {
                            if (versionCnt >= 36) break;
                            version[versionCnt++] = buffer[i];
                            ++i;
                        }
                        if (versionCnt != 36) continue;
                        GpEquipmentPort.this.mRequestVersion = false;
                        GpEquipmentPort.this.mPrepareUpdate = true;
                        versionCnt = 0;
                        if (this.checkVersion(new String(version, 0, version.length), new File(GpEquipmentPort.this.mPath).getName())) {
                            Log.d((String)"====", (String)"prepareUpdate");
                            GpEquipmentPort.this.prepareUpdate();
                            continue;
                        }
                        GpEquipmentPort.this.resetFlag();
                        GpEquipmentPort.this.callbackDisplayUpdateFail("\u7248\u672c\u9519\u8bef");
                        continue;
                    }
                    if (size == 2) {
                        switch (buffer[0]) {
                            case 2: {
                                GpEquipmentPort.this.callbackBacklightStatus(buffer[1]);
                            }
                        }
                        continue;
                    }
                    if (size == 3) {
                        switch (buffer[0]) {
                            case 1: {
                                GpEquipmentPort.this.callbackBacklightTimeout(buffer[1] & 0xFF, buffer[2] & 0xFF);
                                break;
                            }
                            case 3: {
                                GpEquipmentPort.this.callbackCursorPosition(buffer[1], buffer[2]);
                                break;
                            }
                            case 4: {
                                GpEquipmentPort.this.callbackDisplayRowAndColumn(buffer[1], buffer[2] & 0xFF);
                            }
                        }
                        continue;
                    }
                    if (size == 4) {
                        Log.d((String)"OK", (String)"-----_OK_------");
                        String ok = new String(buffer, 0, size);
                        if (GpEquipmentPort.this.mPrepareUpdate) {
                            if (!"_OK_".equals(ok)) continue;
                            GpEquipmentPort.this.mPrepareUpdate = false;
                            GpEquipmentPort.this.mUpdating = true;
                            Log.d((String)"---ok----", (String)"\u53ef\u4ee5\u5f00\u59cb\u4e0b\u8f7d\u7a0b\u5e8f\u4e86");
                            this.update();
                            continue;
                        }
                        if (GpEquipmentPort.this.mUpdating) {
                            Log.d((String)"====updateing====", (String)(String.valueOf(GpEquipmentPort.this.index) + " -> OK"));
                            this.update();
                            continue;
                        }
                        if (!"_OK_".equals(ok)) continue;
                        GpEquipmentPort.this.mRequestVersion = true;
                        GpEquipmentPort.this.requestVersionInfo();
                        continue;
                    }
                    if (size == 5) {
                        if (buffer[0] != 95 || buffer[1] != 66 || buffer[2] != 85 || buffer[3] != 83 || buffer[4] != 89 || buffer[5] != 95) continue;
                        GpEquipmentPort.this.mPrepareUpdate = false;
                        Log.d((String)"===BUSY===", (String)"\u4e0b\u4f4d\u673a\u5fd9");
                        GpEquipmentPort.this.resetFlag();
                        GpEquipmentPort.this.callbackDisplayUpdateFail("\u4e0b\u4f4d\u673a\u5fd9");
                        continue;
                    }
                    if (size == 7) {
                        if ("_ERROR_".equals(new String(buffer, 0, size))) {
                            if (GpEquipmentPort.this.mPrepareUpdate) {
                                Log.d((String)"===ERROR===", (String)"\u56fa\u4ef6\u9519\u8bef");
                                GpEquipmentPort.this.mPrepareUpdate = false;
                            }
                            GpEquipmentPort.this.resetFlag();
                            GpEquipmentPort.this.callbackDisplayUpdateFail("\u56fa\u4ef6\u9519\u8bef");
                            continue;
                        }
                        boolean isPortOpen = GpEquipmentPort.this.check(buffer, size);
                        GpEquipmentPort.this.callbackIsPortOpen(isPortOpen);
                        continue;
                    }
                    if (size != 8) continue;
                    boolean isFinish = new String(buffer, 0, size).equals("_FINISH_");
                    if (isFinish) {
                        GpEquipmentPort.this.callbackDisplayUpdateSuccess();
                        continue;
                    }
                    GpEquipmentPort.this.updateCheck(buffer, size);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    GpEquipmentPort.this.closeSerialPort();
                    Log.d((String)"GpEquipment", (String)"\u7aef\u53e3\u5173\u95ed");
                    return;
                }
            }
        }

        private boolean checkVersion(String originVersion, String updateVersion) {
            String[] update;
            String[] origin = originVersion.split(",");
            if (!origin[0].equals((update = updateVersion.split(","))[0])) {
                return false;
            }
            String originHardwareVer = origin[1].substring(0, 5);
            float originSoftwareVer = Float.parseFloat(origin[1].substring(5));
            String updateHardwareVer = update[1].substring(0, 5);
            float updateSoftwareVer = Float.parseFloat(update[1].substring(5));
            if (!originHardwareVer.equals(updateHardwareVer)) {
                return false;
            }
            if (originSoftwareVer < updateSoftwareVer) {
                return true;
            }
            String originDateStr = origin[2].replace("_", "/").replace("E", "");
            String updateDateStr = origin[2].replace("_", "/").replace("E", "");
            Date originDate = new Date(originDateStr);
            Date updateDate = new Date(updateDateStr);
            return originDate.getTime() < updateDate.getTime();
        }

        private void update() {
            byte[] d = GpEquipmentPort.this.getUpdateData();
            int length = d.length;
            int sizeL = length % 256;
            int sizeH = length / 256;
            GpEquipmentPort.this.download(GpEquipmentPort.this.mPackOffsetL, GpEquipmentPort.this.mPackOffsetH, sizeL, sizeH, d, d.length);
            GpEquipmentPort gpEquipmentPort = GpEquipmentPort.this;
            gpEquipmentPort.mPackOffsetL = gpEquipmentPort.mPackOffsetL + 1;
            if (GpEquipmentPort.this.mPackOffsetL > 255) {
                GpEquipmentPort.this.mPackOffsetL = 0;
                GpEquipmentPort gpEquipmentPort2 = GpEquipmentPort.this;
                gpEquipmentPort2.mPackOffsetH = gpEquipmentPort2.mPackOffsetH + 1;
            }
        }
    }
}

