/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.gprinter.command.GpCom;
import com.gprinter.io.GpPort;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Vector;

public class EthernetPort
extends GpPort {
    private static final String DEBUG_TAG = "EthernetService";
    private String mIp;
    private int mPortNumber;
    private ConnectThread mConnectThread = null;
    private ConnectedThread mConnectedThread = null;
    private ReachableThread mReachableThread;

    public EthernetPort(int id, String Ip, int Port, Handler handler) {
        Log.e((String)DEBUG_TAG, (String)"recreate Socket");
        this.mState = 0;
        this.mHandler = handler;
        this.mPortNumber = Port;
        this.mIp = Ip;
        this.mPrinterId = id;
    }

    @Override
    public synchronized void connect() {
        Log.d((String)DEBUG_TAG, (String)("connect to Ip :" + this.mIp + " Port: " + this.mPortNumber));
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        this.mConnectThread = new ConnectThread(this.mIp, this.mPortNumber);
        this.mConnectThread.start();
        this.setState(2);
    }

    public synchronized void connected(Socket socket, String ip) {
        Log.d((String)DEBUG_TAG, (String)"connected");
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
        if (this.mReachableThread != null) {
            this.mReachableThread.cancel();
            this.mReachableThread = null;
        }
        this.mConnectedThread = new ConnectedThread(socket);
        this.mConnectedThread.start();
        this.mReachableThread = new ReachableThread(socket);
        Message msg = this.mHandler.obtainMessage(4);
        Bundle bundle = new Bundle();
        bundle.putString("device_name", ip);
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
        this.setState(3);
    }

    @Override
    public synchronized void stop() {
        Log.d((String)DEBUG_TAG, (String)"stop");
        this.setState(0);
        if (this.mConnectThread != null) {
            this.mConnectThread.cancel();
            this.mConnectThread = null;
        }
        if (this.mConnectedThread != null) {
            this.mConnectedThread.cancel();
            this.mConnectedThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GpCom.ERROR_CODE writeDataImmediately(Vector<Byte> data) {
        ConnectedThread r;
        GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
        EthernetPort ethernetPort = this;
        synchronized (ethernetPort) {
            if (this.mState != 3) {
                return GpCom.ERROR_CODE.PORT_IS_NOT_OPEN;
            }
            r = this.mConnectedThread;
        }
        retval = r.writeDataImmediately(data);
        return retval;
    }

    private class ConnectThread
    extends Thread {
        private Socket mmSocket = new Socket();
        private String mmIp;
        InetAddress mmIpAddress;
        SocketAddress mmRemoteAddr;

        public ConnectThread(String Ip, int Port) {
            try {
                this.mmIpAddress = Inet4Address.getByName(Ip);
                this.mmRemoteAddr = new InetSocketAddress(this.mmIpAddress, Port);
                this.mmIp = Ip;
            }
            catch (UnknownHostException e) {
                Log.e((String)EthernetPort.DEBUG_TAG, (String)"IpAddress is invalid", (Throwable)e);
                EthernetPort.this.connectionFailed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Log.i((String)EthernetPort.DEBUG_TAG, (String)"BEGIN mConnectThread");
            this.setName("ConnectThread");
            Log.e((String)EthernetPort.DEBUG_TAG, (String)this.mmRemoteAddr.toString());
            try {
                this.mmSocket.connect(this.mmRemoteAddr, 4000);
            }
            catch (IOException e) {
                EthernetPort.this.connectionFailed();
                Log.e((String)EthernetPort.DEBUG_TAG, (String)"connectThread failed");
                try {
                    if (this.mmSocket != null) {
                        this.mmSocket.close();
                    }
                }
                catch (IOException e1) {
                    Log.e((String)EthernetPort.DEBUG_TAG, (String)"unable to close() socket during connection failure", (Throwable)e1);
                }
                EthernetPort.this.stop();
                return;
            }
            EthernetPort ethernetPort = EthernetPort.this;
            synchronized (ethernetPort) {
                EthernetPort.this.mConnectThread = null;
            }
            EthernetPort.this.connected(this.mmSocket, this.mmIp);
        }

        public void cancel() {
            try {
                this.mmSocket.close();
            }
            catch (IOException e) {
                Log.e((String)EthernetPort.DEBUG_TAG, (String)"close() of connect socket failed", (Throwable)e);
                EthernetPort.this.closePortFailed();
            }
        }
    }

    private class ConnectedThread
    extends Thread {
        private final Socket mmSocket;
        private final InputStream mmInStream;
        private final OutputStream mmOutStream;

        public ConnectedThread(Socket socket) {
            Log.d((String)EthernetPort.DEBUG_TAG, (String)"create ConnectedThread");
            this.mmSocket = socket;
            InputStream tmpIn = null;
            OutputStream tmpOut = null;
            try {
                tmpIn = socket.getInputStream();
                tmpOut = socket.getOutputStream();
            }
            catch (IOException e) {
                Log.e((String)EthernetPort.DEBUG_TAG, (String)"temp sockets not created", (Throwable)e);
            }
            this.mmInStream = tmpIn;
            this.mmOutStream = tmpOut;
        }

        @Override
        public void run() {
            Log.i((String)EthernetPort.DEBUG_TAG, (String)"BEGIN mConnectedThread");
            EthernetPort.this.mClosePort = false;
            EthernetPort.this.mReachableThread = new ReachableThread(this.mmSocket);
            EthernetPort.this.mReachableThread.start();
            while (!EthernetPort.this.mClosePort) {
                try {
                    byte[] ReceiveData = new byte[100];
                    int bytes = this.mmInStream.read(ReceiveData);
                    Log.d((String)EthernetPort.DEBUG_TAG, (String)("bytes " + bytes));
                    if (bytes > 0) {
                        Message msg = EthernetPort.this.mHandler.obtainMessage(2);
                        Bundle bundle = new Bundle();
                        bundle.putInt("printer.id", EthernetPort.this.mPrinterId);
                        bundle.putInt("device.readcnt", bytes);
                        bundle.putByteArray("device.read", ReceiveData);
                        msg.setData(bundle);
                        EthernetPort.this.mHandler.sendMessage(msg);
                        continue;
                    }
                    Log.e((String)EthernetPort.DEBUG_TAG, (String)"disconnected");
                    EthernetPort.this.connectionLost();
                    EthernetPort.this.stop();
                }
                catch (IOException e) {
                    EthernetPort.this.connectionLost();
                    Log.e((String)EthernetPort.DEBUG_TAG, (String)"disconnected", (Throwable)e);
                }
                break;
            }
            Log.d((String)EthernetPort.DEBUG_TAG, (String)"Closing ethernet work");
            EthernetPort.this.setState(0);
        }

        public void cancel() {
            try {
                EthernetPort.this.mClosePort = true;
                this.mmOutStream.flush();
                if (this.mmSocket != null) {
                    this.mmSocket.close();
                }
            }
            catch (IOException e) {
                EthernetPort.this.closePortFailed();
            }
        }

        public GpCom.ERROR_CODE writeDataImmediately(Vector<Byte> data) {
            GpCom.ERROR_CODE retval = GpCom.ERROR_CODE.SUCCESS;
            if (this.mmSocket != null && this.mmOutStream != null) {
                if (data != null && data.size() > 0) {
                    byte[] sendData = new byte[data.size()];
                    if (data.size() > 0) {
                        int i = 0;
                        while (i < data.size()) {
                            sendData[i] = data.get(i);
                            ++i;
                        }
                        try {
                            this.mmOutStream.write(sendData);
                            this.mmOutStream.flush();
                        }
                        catch (Exception e) {
                            Log.d((String)EthernetPort.DEBUG_TAG, (String)("Exception occured while sending data immediately: " + e.getMessage()));
                            retval = GpCom.ERROR_CODE.FAILED;
                        }
                    }
                }
            } else {
                retval = GpCom.ERROR_CODE.PORT_IS_NOT_OPEN;
            }
            return retval;
        }
    }

    class ReachableThread
    extends Thread {
        private Socket mSocket;

        public ReachableThread(Socket socket) {
            this.mSocket = socket;
        }

        public void cancel() {
            try {
                if (this.mSocket != null) {
                    this.mSocket.close();
                }
            }
            catch (IOException e) {
                Log.e((String)EthernetPort.DEBUG_TAG, (String)"close() of connect socket failed", (Throwable)e);
                EthernetPort.this.closePortFailed();
            }
        }

        @Override
        public void run() {
            try {
                Log.e((String)EthernetPort.DEBUG_TAG, (String)"start Reachable");
                while (!EthernetPort.this.mClosePort) {
                    EthernetPort.this.mClosePort = !this.mSocket.getInetAddress().isReachable(5000);
                    Thread.sleep(5000L);
                }
            }
            catch (IOException e) {
                EthernetPort.this.connectionLost();
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

