/*
 * Decompiled with CFR 0.152.
 */
package com.gprinter.io;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.widget.Toast;
import com.gprinter.io.GpEquipmentPort;
import com.gprinter.io.utils.GpUtils;
import com.gprinter.jni.Jni;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class CustomerDisplay
extends GpEquipmentPort {
    private Jni mJni = Jni.getInstance();
    private Context mContext;
    private static CustomerDisplay mCustomerDisplay;

    private CustomerDisplay(Context context) {
        super(context);
        this.mContext = context;
    }

    public static CustomerDisplay getInstance(Context context) {
        if (mCustomerDisplay == null) {
            mCustomerDisplay = new CustomerDisplay(context);
        }
        return mCustomerDisplay;
    }

    public void openPort() throws IOException {
        String path = Build.VERSION.SDK_INT >= 21 ? "/dev/ttyS2" : "/dev/ttyS3";
        File file = new File(path);
        if (!file.exists()) {
            throw new IOException("Not found serial port");
        }
        this.getSerialPort(file, 115200, 0);
    }

    public boolean isPortOpen() {
        return this.mJni.isPortOpen();
    }

    public void setReceivedListener(GpEquipmentPort.OnDataReceived onDataReceived) {
        this.setDataReceived(onDataReceived);
    }

    public void clear() {
        this.mJni.clear();
    }

    public void reset() {
        this.mJni.reset();
        this.closeSerialPort();
    }

    public void setBacklight(boolean isOn) {
        this.mJni.setBacklight(isOn);
    }

    public void setCursorPosition(int x, int y) {
        this.mJni.setCursorPosition(x, y);
    }

    public void setBacklightTimeout(int timeout) {
        this.mJni.setBacklightTimeout(timeout);
    }

    public void setTextCurrentCursor(String text) {
        try {
            byte[] bytes = text.getBytes("GB2312");
            if (bytes.length > 255 && bytes.length <= 0) {
                throw new IllegalArgumentException("the content must be greater than 0 and less than 255");
            }
            this.mJni.setInputInCurrentCursor(bytes, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void setTextBebindCursor(String text) {
        try {
            byte[] bytes = text.getBytes("GB2312");
            if (bytes.length > 255 && bytes.length <= 0) {
                throw new IllegalArgumentException("the content must be greater than 0 and less than 255");
            }
            this.mJni.setInputBebindCursor(bytes, bytes.length);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void getBacklight() {
        this.mJni.getBacklight();
    }

    public void getBacklightTimeout() {
        this.mJni.getBacklightTimeout();
    }

    public void getCursorPosition() {
        this.mJni.getCursorPosition();
    }

    public void getDisplayRowAndColumn() {
        this.mJni.getDisplayRowAndColumn();
    }

    public void swichMode(byte mode) {
        this.mJni.swichMode(mode);
    }

    public void displayBitmap(Bitmap bitmap, int nWidth) {
        if (bitmap != null) {
            int width = (nWidth + 7) / 8 * 8;
            int height = bitmap.getHeight() * width / bitmap.getWidth();
            Bitmap grayBitmap = GpUtils.toGrayscale(bitmap);
            Bitmap rszBitmap = GpUtils.resizeImage(grayBitmap, width, height);
            byte[] src = GpUtils.bitmapToBWPix(rszBitmap);
            byte[] command = new byte[4];
            height = src.length / width;
            command[0] = (byte)(width / 8 % 256);
            command[1] = (byte)(width / 8 / 256);
            command[2] = (byte)(height % 256);
            command[3] = (byte)(height / 256);
            byte[] codecontent = GpUtils.pixToEscRastBitImageCmd(src);
            byte[] bytes = new byte[command.length + codecontent.length];
            System.arraycopy(command, 0, bytes, 0, command.length);
            System.arraycopy(codecontent, 0, bytes, command.length, codecontent.length);
            this.mJni.displayBitmap(bytes, bytes.length);
        }
    }

    public void setContrast(byte contrast) {
        if (contrast < 0 || contrast > 21) {
            Toast.makeText((Context)this.mContext, (CharSequence)"contrast param error", (int)0).show();
            return;
        }
        this.mJni.setContrast(contrast);
    }

    public void setBrightness(byte brightness) {
        if (brightness < 0 || brightness > 5) {
            Toast.makeText((Context)this.mContext, (CharSequence)"brightness param error", (int)0).show();
            return;
        }
        this.mJni.setBrightness(brightness);
    }

    public void setCursorVisible(boolean visible) {
        this.mJni.setCursorVisible(visible);
    }
}

